import java.io.*;

/**
 * Classe contenente le caratteristiche principali di una persona 
 * ai fini del corretto funzionamento di un newsgroup
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 */
public class Person implements Serializable{
	protected String nickname=null;
	protected String name=null;
	protected String surname=null;
	protected String email=null;
	protected String description=null;
	
	/**
	 * Costruttore di persona con un solo parametro
	 * @param nick nickname della persona
	 */
	public Person(String nick){
		this.nickname=nick;
	}
	
	/**
	 * Costruttore di persona con tutti i parametri specificati
	 * @param ni nickname della persona
	 * @param n  nome della persona
	 * @param s  cognome della persona
	 * @param e	 indirizzo email della persona
	 * @param d  descrizione aggiuntiva della persona
	 */
	public Person(String ni,String n,String s,String e,String d){
		this.nickname=ni;
		this.name=n;
		this.surname=s;
		this.email=e;
		this.description=d;
	}
	
	/**
	 * Costruttore di persona con 3 parametri
	 * @param ni nickname della persona
	 * @param n  nome della persona
	 * @param s  cognome della persona
	 */
	public Person(String ni,String n,String s){
		this.nickname=ni;
		this.name=n;
		this.surname=s;
	}
	
	/**
	 * Costruttore di persona con 2 parametri
	 * @param ni nickname della persona
	 * @param e  email della persona
	 */
	public Person(String ni,String e){
		this.nickname=ni;
		this.email=e;
	}
	
	/**
	 * Metodo per ottenere il nome di una persona, potrebbe avere valore nullo
	 * @return nome della persona se conosciuto
	 */
	public String getName(){
		return name;
	}
	
	/**
	 * Metodo per ottenere il cognome di una persona, potrebbe avere valore nullo
	 * @return cognome della persona se noto
	 */
	public String getSurname(){
		return surname;
	}
	
	/**
	 * Metodo per ottenere emial di una persona, potrebbe avere valore nullo
	 * @return email della persona se presente
	 */
	public String getEmail(){
		return email;
	}
	
	/**
	 * Metodo per ottenere l'eventuale ulteriore descrizione di una persona, 
	 * potrebbe avere valore nullo
	 * @return descrizione della persona se noto
	 */
	public String getDescription(){
		return description;
	}
	
	/**
	 * Metodo per ottenere il nickname di una persona, il valore deve essere
	 * presente e non nullo
	 * @return nickname della persona
	 */
	public String getNickname(){
		return nickname;
	}
	
	/**
	 * Metodo per cambiare/inserire l'informazione sul nome
	 * @param n nome della persona
	 */
	public void setName(String n){
		name=n;
	}
	
	/**
	 * Metodo per cambiare/inserire l'informazione sul cognome
	 * @param s cognome della persona
	 */
	public void setSurname(String s){
		surname=s;
	}
	
	/**
	 * Metodo per cambiare/inserire l'informazione sull'email
	 * @param e email della persona
	 */
	public void setEmail(String e){
		email=e;
	}
	
	/**
	 * Metodo per cambiare/inserire ulteriori informazioni sulla persona
	 * @param d descrizione della persona
	 */
	public void setDescription(String d){
		description=d;
	}
	
	/**
	 * Metodo per cambiare il nickname di una persona il valore non pu essere nullo 
	 * @param n nickname della persona
	 */
	public void changeNickname(String n){
		if(n!=null)
			nickname=n;
	}
	
	/**
	 * Metodo che ritorna i valori di tutti i campi della classe se diversi da null
	 * @return Stringa rappresentante la classe Person 
	 */
	public String toString(){
		String app=new String(nickname);
		if(name!=null) app=app.concat("\nNome:"+name);
		if (surname!=null) app=app.concat("\nCognome:"+surname);
		if(email!=null) app=app.concat("\nEmail:"+email);
		if(description!=null) app=app.concat("\nDescrizione:"+description);
		return app;
	}

}
